/**************************************************************************************************\
 *** ComStack_Cfg.h
 ***
 *** Configuration of AUTOSAR COM stack types.
 ***
 *** Author: Carsten Igel
 *** Since:  2015-11-27
 ***
 *** Copyright 2015, dSPACE GmbH. All rights reserved.
\**************************************************************************************************/

#ifndef _COMSTACK_CFG_H_
#define _COMSTACK_CFG_H_

/*------------------------------------------------------------------------------------------------*\
  INCLUDES
\*------------------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------------------------*\
  TYPEDEFS
\*------------------------------------------------------------------------------------------------*/

/*
 * SWS_COMTYPE_00029 :
 * ComStack_Cfg.h shall be generated by the generator to generate the type definition of the PduIdType and PduLengthType from the EcuC Virtual Layer based on the configuration e.g. typedef uint8 PduIdType if number of PDUs are less than 256.
 */

 /*
  * SWS_COMTYPE_00030 :
  * The value of PduIdType and PduLengthType shall be derived from the PduIdTypeEnum and PduLengthTypeEnum of the EcuCPduCollection container respectively.
  */

  /* Violation of SWS_COMTYPE_00005: We allow the range of uint32 */
 /*
  * Type of PDU ID. Allowed ranges: uint8 .. uint16.
  *
  * SWS_COMTYPE_00005 :
  * This type is used within the entire AUTOSAR Com Stack except for bus drivers.
  */
typedef uint32 PduIdType;

/*
 * Type of PDU Length. Allowed ranges: uint8 .. uint32.
 *
 * SWS_COMTYPE_00008 :
 * This type shall be used within the entire AUTOSAR Com Stack of an ECU except for bus drivers.
 */
typedef uint32 PduLengthType;

#endif /* _COMSTACK_CFG_H_ */

/*----------------------------------------------------------------------------*\
  END OF FILE
\*----------------------------------------------------------------------------*/
